package gov.va.med.mhv.admin.converter;

import gov.va.med.mhv.admin.dto.UserEmailAddressHistoryDTO;
import gov.va.med.mhv.admin.model.UserEmailAddressHistory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

@Component
public class UserEmailAddressHistoryConverter  implements Serializable {

	private static final long serialVersionUID = -1547139471761268240L;
	
	public UserEmailAddressHistoryDTO convert(UserEmailAddressHistory source) {
		UserEmailAddressHistoryDTO dto = new UserEmailAddressHistoryDTO();
		dto.setId(source.getId());
		dto.setOplock(source.getOplock());
		dto.setUserProfileId(source.getUserProfileId());
		dto.setEmailAddress(source.getEmailAddress());
		dto.setModifiedDate(source.getModifiedDate());
		dto.setChangedBy(source.getChangedBy());
		dto.setReason(source.getReason());
		return dto;
	}

	public UserEmailAddressHistory convert(UserEmailAddressHistoryDTO dto) {
		UserEmailAddressHistory userEmailAddressHistory = new UserEmailAddressHistory();
		userEmailAddressHistory.setId(dto.getId());
		userEmailAddressHistory.setOplock(dto.getOplock());
		userEmailAddressHistory.setUserProfileId(dto.getUserProfileId());
		userEmailAddressHistory.setEmailAddress(dto.getEmailAddress());
		userEmailAddressHistory.setModifiedDate(dto.getModifiedDate());
		userEmailAddressHistory.setChangedBy(dto.getChangedBy());
		userEmailAddressHistory.setReason(dto.getReason());
		return userEmailAddressHistory;
	}
	
	public List<UserEmailAddressHistoryDTO> convertList(List<UserEmailAddressHistory> userEmailAddressHistoryList) {
		List<UserEmailAddressHistoryDTO> list = new ArrayList<UserEmailAddressHistoryDTO>();

		if (userEmailAddressHistoryList != null) {
			for (UserEmailAddressHistory listItem : userEmailAddressHistoryList) {
				UserEmailAddressHistoryDTO dto = convert(listItem);
				list.add(dto);
			}
		}

		return list;
	}

}
